import os

def get_dataset_classification_dir(dataset):
    base = 'DatasetClassifications'
    if dataset == 'cifar10':
        path = os.path.join(base, '80MCifar10')
    elif dataset == 'cifar100':
        path = os.path.join(base, '80MCifar100')
    elif dataset == 'svhn_extra':
        path = os.path.join(base, 'SVHNExtra')
    elif dataset == 'svhn':
        path = os.path.join(base, '80MSVHNExtra')
    elif dataset == 'imagenet100':
        path = os.path.join(base, 'OpenImagesImageNet100')
    elif dataset == 'pets':
        path = os.path.join(base, 'OpenImagesPets')
    elif dataset == 'flowers':
        path = os.path.join(base, 'OpenImagesFlowers')
    elif dataset == 'food-101':
        path = os.path.join(base, 'OpenImagesFood-101')
    elif dataset == 'cars':
        path = os.path.join(base, 'OpenImagesCars')
    else:
        raise ValueError('Dataset not supported')

    return path

def get_dataset_thresholds_dir(dataset):
    base = get_dataset_classification_dir(dataset)
    threshold_path = os.path.join(base, 'Thresholds')
    return threshold_path
